﻿<%@ Page Title="VTA Patient" Language="C#" MasterPageFile="~/Custom/EFR/Efr.Master" AutoEventWireup="True" 
    CodeBehind="VTAPatient.aspx.cs" Inherits="VIRP_WEB.Custom.EFR.VTAPatient" MaintainScrollPositionOnPostback="true" %>

<asp:Content ID="Content1" ContentPlaceHolderID="HeadContent" Runat="Server">
    <link type = "text/css" href ="styles/StyleSheet.css" rel="stylesheet"/>
    <style type="text/css">
        .style1
        {
            width: 100%;
        }
        .style2
        {
            width: 110px;
        }
        .style3
        {
        }
        .style4
        {
            width: 8px;
        }
        .style6
        {
            width: 110px;
        }
        .style8
        {
            width: 200px;
        }
        .style9
        {
            width: 100px;
        }
        .style10
        {
            width: 110px;
        }
        .style11
        {
            width: 250px;
        }
        .style12
        {
            width: 250px;
        }
        .style13
        {
            width: 200px;
        }
        .style14
        {
            width: 120px;
        } 
    </style>          
</asp:Content> 
<asp:Content ID="Content2" ContentPlaceHolderID = "MainContent" Runat="Server">

    <asp:ObjectDataSource ID="ObjectDataSourceReferralStatus" runat="server" 
            SelectMethod="GetReferralStatusByReferralID" 
            TypeName="VIRP.EFR.BLL.VTA_PATIENTManager" OnSelecting="Ds_Selecting">
            <SelectParameters>
                <asp:QueryStringParameter QueryStringField = "id" Direction = "Input" Name = "REFERRAL_ID" />                
            </SelectParameters> 
     </asp:ObjectDataSource>
     <asp:ObjectDataSource ID="ObjectDataSourceICD9Codes" runat="server" 
            SelectMethod="SelectICD9CodesByPatient"
            SelectCountMethod = "SelectICD9CodesByPatientCount" 
            TypeName="VIRP.EFR.BLL.VTA_PATIENTManager"
            StartRowIndexParameterName="startRow" 
            MaximumRowsParameterName="maxRows" 
            SortParameterName="sort"
            EnablePaging="True" OnSelecting="Ds_Selecting"> 
            <SelectParameters>
                <asp:QueryStringParameter QueryStringField = "patientId" Direction = "Input" Name = "PATIENT_ID" />                
            </SelectParameters> 
     </asp:ObjectDataSource>
     <asp:ObjectDataSource ID="ObjectDataSourceSOAPNotes" runat="server" 
            SelectMethod="SelectSoapNoteByPatient"
            SelectCountMethod = "SelectSoapNoteByPatientCount" 
            TypeName="VIRP.EFR.BLL.VTA_PATIENTManager"
            StartRowIndexParameterName="startRow" 
            MaximumRowsParameterName="maxRows" 
            SortParameterName="sort"
            EnablePaging="True" OnSelecting="Ds_Selecting"> 
            <SelectParameters>
                <asp:QueryStringParameter QueryStringField = "patientId" Direction = "Input" Name = "PATIENT_ID" />                
            </SelectParameters> 
     </asp:ObjectDataSource>
    
    <table>
        <tr>
            <td>
                <asp:Panel ID="PanelPatientInformationDetails" runat="server" GroupingText="&nbsp;&nbsp;VTA Patient Information Details&nbsp;&nbsp;" Width = "100%">
                <table align="left" class="style1" cellpadding = "5" cellspacing = "5" border="0">
                    <tr style = "height:18px;">
                    <td class="style3">
                        <asp:Label SkinID="DataLabel" ID="LabelPatientSnum" runat="server" 
                            Text="SSN:" 
                            AssociatedControlID="SnumLabel">
                        </asp:Label>
                    </td>
                    <td>
                        <asp:Label SkinID="DataLabel" ID="SnumLabel" runat="server"/>

                     </td>
                    </tr>
                    <tr style = "height:18px;">
                    <td class="style3">
                        <asp:Label SkinID="DataLabel" ID="LabelPatientICN" runat="server" 
                            Text="Patient ICN:" 
                            AssociatedControlID="LabelICN">
                        </asp:Label>
                    </td>
                    <td>
                        <asp:Label SkinID="DataLabel" ID="LabelICN" runat="server"/>

                     </td>
                    </tr>
                    <tr style = "height:18px;">
                    <td class="style3">
                        <asp:Label SkinID="DataLabel" ID="LabelPatientName" runat="server" 
                            Text="Patient Name:" 
                            AssociatedControlID="PatientNameLabel">
                        </asp:Label>
                    </td>
                    <td>
                        <asp:Label SkinID="DataLabel" ID="PatientNameLabel" runat="server"/>

                     </td>
                   </tr>
                 <tr style = "height:18px;">
                    <td class="style3">
                        <asp:Label SkinID="DataLabel" ID="LabelPatientAddress" runat="server" 
                            Text="Street Address:" 
                            AssociatedControlID="Address1Label">
                        </asp:Label>
                    </td>
                    <td>
                        <asp:Label SkinID="DataLabel" ID="Address1Label" runat="server"/>

                     </td>
                   </tr>
                   <tr style = "height:18px;">
                    <td class="style3">
                        <asp:Label SkinID="DataLabel" ID="LabelPatientCity" runat="server" 
                            Text="City:" 
                            AssociatedControlID="CityLabel">
                        </asp:Label>
                    </td>
                    <td>
                        <asp:Label SkinID="DataLabel" ID="CityLabel" runat="server"/>

                     </td>
                   </tr>
                   <tr style = "height:18px;">
                    <td class="style3">
                        <asp:Label SkinID="DataLabel" ID="LabelPatientState" runat="server" 
                            Text="State:" 
                            AssociatedControlID="StateLabel">
                        </asp:Label>
                    </td>
                    <td>
                        <asp:Label SkinID="DataLabel" ID="StateLabel" runat="server"/>

                     </td>
                   </tr>
                  <tr style = "height:18px;">
                    <td class="style3">
                        <asp:Label SkinID="DataLabel" ID="LabelPatientZipCode" runat="server" 
                            Text="Zip/Postal Code:" 
                            AssociatedControlID="ZipCodeLabel">
                        </asp:Label>
                    </td>
                    <td>
                        <asp:Label SkinID="DataLabel" ID="ZipCodeLabel" runat="server"/>

                     </td>
                   </tr>
                   <tr style = "height:18px;">
                    <td class="style3">
                        <asp:Label SkinID="DataLabel" ID="LabelforLabelCountry" runat="server" 
                            Text="Country:" 
                            AssociatedControlID="CountryLabel">
                        </asp:Label>
                    </td>
                    <td>
                        <asp:Label SkinID="DataLabel" ID="CountryLabel" runat="server"/>

                     </td>
                   </tr>
                  <tr style = "height:18px;">
                    <td class="style3">
                        <asp:Label SkinID="DataLabel" ID="LabelPatientHomePhone" runat="server" 
                            Text="Home Phone:" 
                            AssociatedControlID="HomePhoneLabel">
                        </asp:Label>
                    </td>
                    <td>
                        <asp:Label SkinID="DataLabel" ID="HomePhoneLabel" runat="server"/>

                     </td>
                   </tr>
                   <tr style = "height:18px;">
                    <td class="style3">
                        <asp:Label SkinID="DataLabel" ID="LabelforWorkPhone" runat="server" 
                            Text="Work Phone:" 
                            AssociatedControlID="WorkPhoneLabel">
                        </asp:Label>
                    </td>
                    <td>
                        <asp:Label SkinID="DataLabel" ID="WorkPhoneLabel" runat="server"/>

                     </td>
                   </tr>
                   <tr style = "height:18px;">
                    <td class="style3">
                        <asp:Label SkinID="DataLabel" ID="LabelforLabelOefOifIndicator" runat="server" 
                            Text="OEF/OIF Indicator:" 
                            AssociatedControlID="LabelOefOifIndicator">
                        </asp:Label>
                    </td>
                    <td>
                        <asp:Label SkinID="DataLabel" ID="LabelOefOifIndicator" runat="server"/>

                     </td>
                   </tr>
                   <tr style = "height:18px;">
                    <td class="style3">
                        <asp:Label SkinID="DataLabel" ID="LabelforLabelDOB" runat="server" 
                            Text="Date of Birth:" 
                            AssociatedControlID="LabelDOB">
                        </asp:Label>
                    </td>
                    <td>
                        <asp:Label SkinID="DataLabel" ID="LabelDOB" runat="server"/>

                     </td>
                   </tr>
                   <tr style = "height:18px;">
                    <td class="style3">
                        <asp:Label SkinID="DataLabel" ID="LabelforLabelDateOfDeath" runat="server" 
                            Text="Date of Death:" 
                            AssociatedControlID="LabelDateOfDeath">
                        </asp:Label>
                    </td>
                    <td>
                        <asp:Label SkinID="DataLabel" ID="LabelDateOfDeath" runat="server"/>

                     </td>
                   </tr>
                   <tr style = "height:18px;">
                    <td class="style3">
                        <asp:Label SkinID="DataLabel" ID="LabelforLabelGenderCode" runat="server" 
                            Text="Gender:" 
                            AssociatedControlID="LabelGenderCode">
                        </asp:Label>
                    </td>
                    <td>
                        <asp:Label SkinID="DataLabel" ID="LabelGenderCode" runat="server"/>

                     </td>
                   </tr>
                   <tr style = "height:18px;">
                    <td class="style3">
                        <asp:Label SkinID="DataLabel" ID="LabelforLabelServiceBranch" runat="server" 
                            Text="Service Branch Code:" 
                            AssociatedControlID="LabelServiceBranch">
                        </asp:Label>
                    </td>
                    <td>
                        <asp:Label SkinID="DataLabel" ID="LabelServiceBranch" runat="server"/>

                     </td>
                   </tr>
                 </table> 
                </asp:Panel> 
            </td> 
        </tr>
        <tr>
            <td>
                <asp:Panel ID="ICD9CodesPanel" runat="server" GroupingText="&nbsp;&nbsp;Case Definition Details&nbsp;&nbsp;" Width = "100%">   
                    <asp:GridView ID="GridViewICD9Codes" runat="server" PageSize="20" 
                    AutoGenerateColumns="False" DataKeyNames="CODE" AllowPaging = "true" 
                    AllowSorting = "true" DataSourceID = "ObjectDataSourceICD9Codes" SkinID ="Unsortable" Width = "98%">
                    <EmptyDataTemplate>
                        This patient does not have any ICD9 codes.
                    </EmptyDataTemplate> 
                        <Columns>                
                            <asp:TemplateField HeaderText="ICD9 Code" SortExpression = "CODE">
                            <ItemTemplate>
                                <asp:Label SkinID="DataLabel" ID="Label1" runat="server" Text='<%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Convert.ToString(Eval("CODE"))) %>'></asp:Label>
                            </ItemTemplate>
                            </asp:TemplateField>
                            <asp:TemplateField HeaderText="Description">
                                <ItemTemplate>
                                    <asp:Label SkinID="DataLabel" ID="LabelSite" runat="server" Text='<%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Convert.ToString(Eval("DESCRIPTION_TEXT"))) %>'></asp:Label>
                                </ItemTemplate>
                            </asp:TemplateField>                
                        </Columns> 
                    </asp:GridView>
                    <br />
                    <br />
                     <asp:GridView ID="GridViewSOAPNote" runat="server" PageSize="20" 
                    AutoGenerateColumns="False" DataKeyNames="VTA_PATIENT_SOAP_KEYWORD_ID" AllowPaging = "true" 
                    AllowSorting = "true" DataSourceID = "ObjectDataSourceSOAPNotes" SkinID = "Unsortable" Width = "98%">
                    <EmptyDataTemplate>
                        This patient does not have any SOAP notes.
                    </EmptyDataTemplate> 
                        <Columns>                
                            <asp:TemplateField HeaderText="SOAP Note Keywords" SortExpression = "ICD9_CODE">
                            <ItemTemplate>
                                <asp:Label SkinID="DataLabel" ID="Label1" runat="server" Text='<%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Convert.ToString(Eval("SOAP_KEYWORD"))) %>'></asp:Label>
                            </ItemTemplate>
                            </asp:TemplateField>                                     
                        </Columns> 
                    </asp:GridView>
                    <br />
                </asp:Panel> 
            </td>
        </tr> 
        
        <tr>
            <td>
                <center>
                    <asp:Button ID = "BackButton" runat = "server" 
                    Text = "Back" Width = "130px" PostBackUrl="javascript:history.go(-1);" UseSubmitBehavior = "false" CssClass = "cancel"/>
                </center>               
            </td>
        </tr>               
    </table>
    
</asp:Content> 
